﻿<?php
require __DIR__ . '/bootstrap.php';
$pdo = db();

// Xử lý AJAX: add / edit / delete
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json; charset=utf-8');

    // Thêm tài khoản (đơn lẻ hoặc qua CSV)
    if ($_POST['action'] === 'add') {
        // Nếu upload file CSV
        if (isset($_FILES['csv']) && isset($_FILES['csv']['error']) && $_FILES['csv']['error'] === UPLOAD_ERR_OK) {
            $file = $_FILES['csv']['tmp_name'];
            $handle = @fopen($file, 'r');
            if (!$handle) {
                echo json_encode(['ok' => false, 'error' => 'Không đọc được file CSV']);
                exit;
            }
            $count = 0;
            while (($row = fgetcsv($handle)) !== false) {
                $username = trim($row[0] ?? '');
                $password = trim($row[1] ?? '');
                $roleRaw = $row[2] ?? 'student';
                $role = in_array($roleRaw, ['student','admin']) ? $roleRaw : 'student';
                if ($username !== '' && $password !== '') {
                    $st = $pdo->prepare('INSERT IGNORE INTO accounts (username, password_md5, role, created_at) VALUES (?, ?, ?, NOW())');
                    $st->execute([$username, md5($password), $role]);
                    $count++;
                }
            }
            fclose($handle);
            echo json_encode(['ok' => true, 'added' => $count]);
            exit;
        }

        // Thêm 1 tài khoản qua form
        $username = trim((string)($_POST['username'] ?? ''));
        $password = (string)($_POST['password'] ?? '');
        $roleRaw = $_POST['role'] ?? 'student';
        $role = in_array($roleRaw, ['student','admin']) ? $roleRaw : 'student';
        if ($username === '' || $password === '') {
            echo json_encode(['ok' => false, 'error' => 'Thiếu tài khoản hoặc mật khẩu']);
            exit;
        }
        $st = $pdo->prepare('INSERT IGNORE INTO accounts (username, password_md5, role, created_at) VALUES (?, ?, ?, NOW())');
        $st->execute([$username, md5($password), $role]);
        echo json_encode(['ok' => true, 'added' => $pdo->rowCount()]);
        exit;
    }

    // Xóa tài khoản
    if ($_POST['action'] === 'delete' && isset($_POST['id'])) {
        $delId = (int)$_POST['id'];
        $pdo->prepare('DELETE FROM accounts WHERE id = ?')->execute([$delId]);
        echo json_encode(['ok' => true]);
        exit;
    }

    // Sửa tài khoản
    if (
        $_POST['action'] === 'edit'
        && isset($_POST['id'], $_POST['username'], $_POST['role'])
    ) {
        $id = (int)$_POST['id'];
        $username = trim($_POST['username']);
        $role = in_array($_POST['role'], ['student','admin']) ? $_POST['role'] : 'student';
        $sql = 'UPDATE accounts SET username = ?, role = ?';
        $params = [$username, $role];
        if (!empty($_POST['password'])) {
            $sql .= ', password_md5 = ?';
            $params[] = md5($_POST['password']);
        }
        $sql .= ' WHERE id = ?';
        $params[] = $id;
        $pdo->prepare($sql)->execute($params);
        echo json_encode(['ok' => true]);
        exit;
    }

    echo json_encode(['ok' => false, 'error' => 'Thao tác không hợp lệ']);
    exit;
}

$accounts = $pdo->query('SELECT id, username, role, created_at FROM accounts ORDER BY id DESC')->fetchAll();
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Thêm tài khoản</title>
    <style>
        body { font-family: 'Inter', sans-serif; background: #18181b; color: #f3f4f6; }
        .account-table { width: 100%; border-collapse: collapse; margin-top: 2rem; }
        .account-table th, .account-table td { padding: 0.5rem 1rem; border-bottom: 1px solid #334155; }
        .account-table th { background: #1e293b; color: #38bdf8; }
        .account-table tr:hover { background: #334155; }
        button { border: none; border-radius: 4px; padding: 4px 10px; cursor: pointer; }
    </style>
</head>
<body>
        <h2 style="color:#38bdf8;">Thêm tài khoản mới</h2>
        <form id="addForm" method="post" enctype="multipart/form-data" style="margin-bottom:2rem; background:#1e293b; padding:1.5rem; border-radius:1rem; max-width:420px;">
            <div style="margin-bottom:1rem;">
                <label>Tên tài khoản</label>
                <input type="text" name="username" style="width:100%;">
            </div>
            <div style="margin-bottom:1rem;">
                <label>Mật khẩu</label>
                <input type="password" name="password" style="width:100%;">
            </div>
            <div style="margin-bottom:1rem;">
                <label>Vai trò</label>
                <select name="role" style="width:100%;">
                    <option value="student">Học viên</option>
                    <option value="admin">Quản trị</option>
                </select>
            </div>
            <div style="margin-bottom:1rem;">
                <label>Hoặc upload file CSV</label>
                <input type="file" name="csv" accept=".csv" style="width:100%;">
                <small style="color:#38bdf8;">Mẫu file CSV: <br> <code>username,password,role</code> <br>Ví dụ:<br><code>tk1,123,student<br>admin,admin123,admin</code></small>
            </div>
            <button type="submit" style="background:#38bdf8; color:#18181b; font-weight:600; border:none; border-radius:0.5rem; padding:0.75rem 1.5rem;">Thêm tài khoản</button>
            <div id="add-error" style="color:#ef4444; margin-top:1rem;"></div>
        </form>
        <script>
        document.getElementById('addForm').onsubmit = async function(e) {
            e.preventDefault();
            const form = e.target;
            const fd = new FormData(form);
            fd.append('action', 'add');
            document.getElementById('add-error').textContent = '';
            try {
                const res = await fetch('admin_account_add.php', { method:'POST', body:fd });
                const json = await res.json();
                if (json.ok) location.reload();
                else document.getElementById('add-error').textContent = json.error || 'Lỗi';
            } catch (err) {
                document.getElementById('add-error').textContent = 'Lỗi hệ thống: ' + err.message;
            }
        };
        </script>

    <table class="account-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Username</th>
                <th>Role</th>
                <th>Created At</th>
                <th>Thao tác</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($accounts as $acc): ?>
            <tr>
                <td><?= htmlspecialchars($acc['id']) ?></td>
                <td><?= htmlspecialchars($acc['username']) ?></td>
                <td><?= htmlspecialchars($acc['role']) ?></td>
                <td><?= htmlspecialchars($acc['created_at']) ?></td>
                <td>
                    <button class="edit-btn" data-id="<?= $acc['id'] ?>" data-username="<?= htmlspecialchars($acc['username']) ?>" data-role="<?= $acc['role'] ?>" style="background:#38bdf8; color:#18181b; margin-right:8px;">Sửa</button>
                    <button class="delete-btn" data-id="<?= $acc['id'] ?>" style="background:#ef4444; color:#fff;">Xóa</button>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>

<!-- Popup sửa tài khoản -->
<div id="editModal" style="display:none; position:fixed; top:0; left:0; width:100vw; height:100vh; background:rgba(0,0,0,0.5); z-index:1000; align-items:center; justify-content:center;">
    <div style="background:#1e293b; border-radius:1rem; padding:2rem; min-width:320px; max-width:90vw; margin:auto; color:#f3f4f6;">
        <h3 style="color:#38bdf8; margin-bottom:1rem;">Sửa tài khoản</h3>
        <form id="editForm">
            <input type="hidden" name="id" id="edit-id">
            <div style="margin-bottom:1rem;">
                <label>Tên tài khoản</label>
                <input type="text" name="username" id="edit-username" style="width:100%;">
            </div>
            <div style="margin-bottom:1rem;">
                <label>Mật khẩu mới (nếu đổi)</label>
                <input type="password" name="password" id="edit-password" style="width:100%;">
            </div>
            <div style="margin-bottom:1rem;">
                <label>Vai trò</label>
                <select name="role" id="edit-role" style="width:100%;">
                    <option value="student">Học viên</option>
                    <option value="admin">Quản trị</option>
                </select>
            </div>
            <div id="edit-error" style="color:#ef4444; margin-bottom:1rem;"></div>
            <div style="display:flex; gap:1rem; justify-content:end;">
                <button type="button" id="edit-cancel" style="background:#334155; color:#fff;">Hủy</button>
                <button type="submit" style="background:#38bdf8; color:#18181b;">Lưu</button>
            </div>
        </form>
    </div>
</div>

<script>
document.querySelectorAll('.edit-btn').forEach(btn => {
    btn.addEventListener('click', function() {
        document.getElementById('editModal').style.display = 'flex';
        document.getElementById('edit-id').value = btn.dataset.id;
        document.getElementById('edit-username').value = btn.dataset.username;
        document.getElementById('edit-role').value = btn.dataset.role;
        document.getElementById('edit-password').value = '';
        document.getElementById('edit-error').textContent = '';
    });
});
document.getElementById('edit-cancel').onclick = function() {
    document.getElementById('editModal').style.display = 'none';
};
document.getElementById('editForm').onsubmit = async function(e) {
    e.preventDefault();
    const form = e.target;
    const fd = new FormData(form);
    fd.append('action', 'edit');
    const res = await fetch('admin_account_add.php', { method:'POST', body:fd });
    const json = await res.json();
    if (json.ok) {
        location.reload();
    } else {
        document.getElementById('edit-error').textContent = json.error || 'Lỗi';
    }
};
document.querySelectorAll('.delete-btn').forEach(btn => {
    btn.addEventListener('click', async function() {
        if (!confirm('Bạn chắc chắn muốn xóa tài khoản này?')) return;
        const fd = new FormData();
        fd.append('action', 'delete');
        fd.append('id', btn.dataset.id);
        const res = await fetch('admin_account_add.php', { method:'POST', body:fd });
        const json = await res.json();
        if (json.ok) location.reload();
        else alert(json.error || 'Lỗi');
    });
});
</script>
</body>
</html>
