<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

require_admin();
$pdo = db();

$status = isset($_GET['status']) ? trim((string)$_GET['status']) : '';
$where = '';
$params = [];
if (in_array($status, ['open','resolved'], true)) {
    $where = 'WHERE f.status = ?';
    $params[] = $status;
}

$sql = "SELECT f.id, f.question_id, f.message, f.status, f.created_at, f.admin_note,
               a.username,
               q.title AS question_title, q.topic AS question_topic, q.difficulty AS question_difficulty, q.type AS question_type
        FROM feedbacks f
        LEFT JOIN accounts a ON a.id = f.account_id
        LEFT JOIN questions q ON q.id = f.question_id
        $where
        ORDER BY f.created_at DESC
        LIMIT 500";

$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();
json_ok(['feedbacks' => $rows]);

