<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

require_admin();
$in = json_input();
$id = isset($in['id']) ? (int)$in['id'] : 0;
if ($id <= 0) json_error('Thiếu id');
$status = isset($in['status']) ? trim((string)$in['status']) : '';
$adminNote = isset($in['admin_note']) ? (string)$in['admin_note'] : null;

if ($status !== '' && !in_array($status, ['open','resolved'], true)) {
    json_error('Trạng thái không hợp lệ');
}

$pdo = db();
$fields = [];
$params = [];
if ($status !== '') {
    $fields[] = 'status = ?';
    $params[] = $status;
    if ($status === 'resolved') {
        $fields[] = 'resolved_at = NOW()';
    } else {
        $fields[] = 'resolved_at = NULL';
    }
}
if ($adminNote !== null) {
    $fields[] = 'admin_note = ?';
    $params[] = $adminNote;
}
if (empty($fields)) json_error('Không có thay đổi');
$params[] = $id;

$sql = 'UPDATE feedbacks SET ' . implode(', ', $fields) . ' WHERE id = ?';
$pdo->prepare($sql)->execute($params);
json_ok(['updated' => true]);

