<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

require_admin();
$in = json_input();
$questionId = trim((string)($in['id'] ?? ''));
if ($questionId === '') json_error('Thiếu id');

$pdo = db();
$st = $pdo->prepare('SELECT id, type, topic, title, difficulty, explanation, code, question, options, correct_answer, task, initial_code, solution, expected_output, active FROM questions WHERE id = ?');
$st->execute([$questionId]);
$q = $st->fetch();
if (!$q) json_error('Không tìm thấy câu hỏi', 404);
if (isset($q['options']) && is_string($q['options'])) {
    $opts = json_decode($q['options'], true);
    if (is_array($opts)) $q['options'] = $opts;
}
json_ok(['question' => $q]);

