<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

require_admin();
$pdo = db();

$in = json_input();
$id = isset($in['id']) ? trim((string)$in['id']) : '';
$type = trim((string)($in['type'] ?? ''));
$title = trim((string)($in['title'] ?? ''));
$topicId = isset($in['topicId']) ? (int)$in['topicId'] : 0;
$difficulty = trim((string)($in['difficulty'] ?? ''));
$active = isset($in['active']) ? (int)((bool)$in['active']) : 1;

if (!in_array($type, ['multiple_choice','interactive'], true)) json_error('Loại câu hỏi không hợp lệ');
if (!in_array($difficulty, ['easy','medium','hard'], true)) json_error('Độ khó không hợp lệ');
if ($title === '') json_error('Thiếu tiêu đề');
if ($topicId <= 0) json_error('Thiếu chủ đề');

// Resolve topic name
$st = $pdo->prepare('SELECT name FROM topics WHERE id = ?');
$st->execute([$topicId]);
$trow = $st->fetch();
if (!$trow) json_error('Chủ đề không tồn tại', 404);
$topicName = (string)$trow['name'];

// Collect fields
$explanation = (string)($in['explanation'] ?? null);
$code = (string)($in['code'] ?? null);
$question = (string)($in['question'] ?? null);
$options = $in['options'] ?? null; // array or null
if ($options !== null && !is_array($options)) json_error('Options phải là mảng');
$correct = (string)($in['correctAnswer'] ?? null);
$task = (string)($in['task'] ?? null);
$initial = (string)($in['initialCode'] ?? null);
$solution = (string)($in['solution'] ?? null);
$expected = (string)($in['expectedOutput'] ?? null);

// Validation light per type
if ($type === 'multiple_choice') {
    if ($question === '' || empty($options) || $correct === '') json_error('Thiếu nội dung trắc nghiệm');
}
if ($type === 'interactive') {
    if ($task === '' || $initial === '') json_error('Thiếu nội dung bài tương tác');
}

// Serialize options
$optionsJson = $options !== null ? json_encode(array_values($options), JSON_UNESCAPED_UNICODE) : null;

try {
    if ($id !== '') {
        $sql = 'UPDATE questions SET type=?, topic=?, title=?, difficulty=?, explanation=?, code=?, question=?, options=?, correct_answer=?, task=?, initial_code=?, solution=?, expected_output=?, active=? WHERE id=?';
        $vals = [$type, $topicName, $title, $difficulty, $explanation, $code, $question, $optionsJson, $correct, $task, $initial, $solution, $expected, $active, $id];
        $pdo->prepare($sql)->execute($vals);
        json_ok(['id' => $id, 'updated' => true]);
    } else {
        // Generate new string id
        $newId = 'q_' . substr(md5(uniqid('', true)), 0, 10);
        $sql = 'INSERT INTO questions (id, type, topic, title, difficulty, explanation, code, question, options, correct_answer, task, initial_code, solution, expected_output, active) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $vals = [$newId, $type, $topicName, $title, $difficulty, $explanation, $code, $question, $optionsJson, $correct, $task, $initial, $solution, $expected, $active];
        $pdo->prepare($sql)->execute($vals);
        json_ok(['id' => $newId, 'created' => true]);
    }
} catch (Throwable $e) {
    json_error('Lưu câu hỏi thất bại: ' . $e->getMessage(), 500);
}
