<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

require_admin();
$pdo = db();

// Support GET with query params: topicId, difficulty, q
$topicId = isset($_GET['topicId']) ? (int)$_GET['topicId'] : 0;
$difficulty = isset($_GET['difficulty']) ? trim((string)$_GET['difficulty']) : '';
$q = isset($_GET['q']) ? trim((string)$_GET['q']) : '';

$params = [];
$wheres = ['active = 1 OR active = 0']; // no-op, keeps WHERE structure

if ($topicId > 0) {
    $st = $pdo->prepare('SELECT name FROM topics WHERE id = ?');
    $st->execute([$topicId]);
    $trow = $st->fetch();
    if ($trow) {
        $wheres[] = 'topic = ?';
        $params[] = $trow['name'];
    }
}
if (in_array($difficulty, ['easy','medium','hard'], true)) {
    $wheres[] = 'difficulty = ?';
    $params[] = $difficulty;
}
if ($q !== '') {
    $wheres[] = '(title LIKE ? OR explanation LIKE ? OR question LIKE ?)';
    $params[] = "%$q%"; $params[] = "%$q%"; $params[] = "%$q%";
}

$whereSql = 'WHERE ' . implode(' AND ', $wheres);
$sql = "SELECT id, type, topic, title, difficulty, explanation, code, question, options, correct_answer, task, initial_code, solution, expected_output, active
        FROM questions
        $whereSql
        ORDER BY id DESC
        LIMIT 300";
$st2 = $pdo->prepare($sql);
$st2->execute($params);
$rows = $st2->fetchAll();

// Normalize options
foreach ($rows as &$r) {
    if (isset($r['options']) && is_string($r['options'])) {
        $opts = json_decode($r['options'], true);
        if (is_array($opts)) $r['options'] = $opts;
    }
}

json_ok(['questions' => $rows]);

