<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

require_admin();
$pdo = db();

// Summary per account: attempts, correct, mastery, last activity
$sql = "
SELECT a.id AS account_id,
       a.username,
       COALESCE(SUM(CASE WHEN at.id IS NOT NULL THEN 1 ELSE 0 END), 0) AS attempts,
       COALESCE(SUM(CASE WHEN at.is_correct = 1 THEN 1 ELSE 0 END), 0) AS correct,
       CASE WHEN COALESCE(SUM(CASE WHEN at.id IS NOT NULL THEN 1 ELSE 0 END), 0) > 0
            THEN (COALESCE(SUM(CASE WHEN at.is_correct = 1 THEN 1 ELSE 0 END), 0) / COALESCE(SUM(CASE WHEN at.id IS NOT NULL THEN 1 ELSE 0 END), 0))
            ELSE 0 END AS mastery,
       MAX(at.created_at) AS last_activity
FROM accounts a
LEFT JOIN users u ON u.account_id = a.id
LEFT JOIN attempts at ON at.user_id = u.id
GROUP BY a.id, a.username
ORDER BY (last_activity IS NULL) ASC, last_activity DESC, attempts DESC, a.username ASC;
";

$rows = $pdo->query($sql)->fetchAll();
json_ok(['overview' => $rows]);
