<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

require_admin();
$in = json_input();
$name = trim((string)($in['name'] ?? ''));
if ($name === '') json_error('Tên chủ đề không được rỗng');

$pdo = db();
try {
    $st = $pdo->prepare('INSERT INTO topics (name, created_at) VALUES (?, NOW())');
    $st->execute([$name]);
    json_ok(['id' => (int)$pdo->lastInsertId(), 'name' => $name]);
} catch (Throwable $e) {
    if (strpos($e->getMessage(), 'Duplicate') !== false) {
        json_error('Chủ đề đã tồn tại');
    }
    json_error('Không thể tạo chủ đề: ' . $e->getMessage(), 500);
}

