<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

require_admin();
$in = json_input();
$id = isset($in['id']) ? (int)$in['id'] : 0;
if ($id <= 0) json_error('Thiếu id');

$pdo = db();
// Find name
$st = $pdo->prepare('SELECT name FROM topics WHERE id = ?');
$st->execute([$id]);
$row = $st->fetch();
if (!$row) json_error('Không tìm thấy chủ đề', 404);
$name = (string)$row['name'];

// Check references by questions.topic string
$st2 = $pdo->prepare('SELECT COUNT(*) AS c FROM questions WHERE topic = ?');
$st2->execute([$name]);
$cnt = (int)$st2->fetch()['c'];
if ($cnt > 0) {
    json_error('Không thể xóa: đang có ' . $cnt . ' câu hỏi thuộc chủ đề này');
}

$pdo->prepare('DELETE FROM topics WHERE id = ?')->execute([$id]);
json_ok(['deleted' => true]);

