<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

require_admin();
$in = json_input();
$id = isset($in['id']) ? (int)$in['id'] : 0;
$name = trim((string)($in['name'] ?? ''));
if ($id <= 0 || $name === '') json_error('Thiếu id hoặc tên');

$pdo = db();
try {
    $st = $pdo->prepare('UPDATE topics SET name = ? WHERE id = ?');
    $st->execute([$name, $id]);
    json_ok(['id' => $id, 'name' => $name]);
} catch (Throwable $e) {
    if (strpos($e->getMessage(), 'Duplicate') !== false) {
        json_error('Chủ đề đã tồn tại');
    }
    json_error('Không thể cập nhật chủ đề: ' . $e->getMessage(), 500);
}

