<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

require_admin();
$pdo = db();

$in = json_input();
$accountId = isset($in['accountId']) ? (int)$in['accountId'] : 0;
if ($accountId <= 0) json_error('accountId is required');

// Find user ids for this account
$st = $pdo->prepare('SELECT id FROM users WHERE account_id = ?');
$st->execute([$accountId]);
$userIds = array_map(fn($r) => (int)$r['id'], $st->fetchAll());
if (empty($userIds)) {
    json_ok(['byQuestion' => [], 'summary' => ['attempts' => 0, 'correct' => 0, 'mastery' => 0]]);
}

$inClause = implode(',', array_fill(0, count($userIds), '?'));
$sql = "SELECT question_id,
               COALESCE(MIN(topic), '') AS topic,
               COALESCE(MIN(difficulty), '') AS difficulty,
               COUNT(*) AS attempts,
               SUM(CASE WHEN is_correct = 1 THEN 1 ELSE 0 END) AS correct
        FROM attempts
        WHERE user_id IN ($inClause)
        GROUP BY question_id";
$st2 = $pdo->prepare($sql);
$st2->execute($userIds);
$rows = $st2->fetchAll();

$byQ = [];
$attempts = 0; $correct = 0;
foreach ($rows as $r) {
    $a = (int)$r['attempts'];
    $c = (int)$r['correct'];
    $attempts += $a; $correct += $c;
    $byQ[$r['question_id']] = [
        'topic' => $r['topic'],
        'difficulty' => $r['difficulty'],
        'attempts' => $a,
        'correct' => $c,
        'mastery' => $a > 0 ? ($c / $a) : 0,
    ];
}
$summary = [
    'attempts' => $attempts,
    'correct' => $correct,
    'mastery' => $attempts > 0 ? ($correct / $attempts) : 0,
];

json_ok(['byQuestion' => $byQ, 'summary' => $summary]);

