<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

$data = json_input();
$easy = max(0, (int)($data['easy'] ?? 0));
$medium = max(0, (int)($data['medium'] ?? 0));
$hard = max(0, (int)($data['hard'] ?? 0));

$userId = current_user_id();

try {
    $pdo = db();
    $stmt = $pdo->prepare('INSERT INTO assessments (user_id, started_at, total_easy, total_medium, total_hard) VALUES (?, NOW(), ?, ?, ?)');
    $stmt->execute([$userId, $easy, $medium, $hard]);
    $assessmentId = (int)$pdo->lastInsertId();
    json_ok(['assessmentId' => $assessmentId]);
} catch (Throwable $e) {
    json_error('Failed to start assessment: ' . $e->getMessage(), 500);
}

