<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

$data = json_input();
$questionId = trim((string)($data['questionId'] ?? ''));
$topic = trim((string)($data['topic'] ?? ''));
$difficulty = trim((string)($data['difficulty'] ?? ''));
$type = trim((string)($data['type'] ?? ''));
$mode = trim((string)($data['mode'] ?? ''));
$isCorrect = (bool)($data['isCorrect'] ?? false);
$assessmentId = isset($data['assessmentId']) && $data['assessmentId'] !== '' ? (int)$data['assessmentId'] : null;

if ($questionId === '' || $difficulty === '' || $type === '' || $mode === '') {
    json_error('Missing required fields');
}

$userId = current_user_id();

try {
    $pdo = db();
    $stmt = $pdo->prepare('INSERT INTO attempts (user_id, question_id, topic, difficulty, type, is_correct, mode, assessment_id, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())');
    $stmt->execute([$userId, $questionId, $topic, $difficulty, $type, $isCorrect ? 1 : 0, $mode, $assessmentId]);
    json_ok(['saved' => true]);
} catch (Throwable $e) {
    json_error('Failed to record attempt: ' . $e->getMessage(), 500);
}

