<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

$pdo = db();
$aid = $_SESSION['account_id'] ?? null;
if (!$aid) {
    json_ok(['loggedIn' => false]);
}

$st = $pdo->prepare('SELECT username, role FROM accounts WHERE id = ?');
$st->execute([(int)$aid]);
$row = $st->fetch();
if (!$row) {
    json_ok(['loggedIn' => false]);
}

// Lấy user_id từ bảng users
$userSt = $pdo->prepare('SELECT id FROM users WHERE account_id = ? LIMIT 1');
$userSt->execute([(int)$aid]);
$userRow = $userSt->fetch();
$userId = $userRow ? (int)$userRow['id'] : null;

// Kiểm tra đã hoàn thành bài kiểm tra trình độ chưa
$assessmentDone = false;
if ($userId) {
    $assessSt = $pdo->prepare('SELECT id FROM assessments WHERE user_id = ? AND ended_at IS NOT NULL LIMIT 1');
    $assessSt->execute([$userId]);
    $assessmentDone = $assessSt->fetch() ? true : false;
}

json_ok([
    'loggedIn' => true,
    'username' => $row['username'],
    'isAdmin' => ($row['role'] === 'admin'),
    'assessmentDone' => $assessmentDone
]);
