<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

$in = json_input();
$questionId = trim((string)($in['questionId'] ?? ''));
$message = trim((string)($in['message'] ?? ''));
if ($questionId === '' || $message === '') {
    json_error('Thiếu questionId hoặc nội dung phản hồi');
}

$pdo = db();
$userId = current_user_id();

// Resolve account id if logged-in
$st = $pdo->prepare('SELECT account_id FROM users WHERE id = ?');
$st->execute([$userId]);
$accId = $st->fetchColumn();
$accId = $accId ? (int)$accId : null;

$ins = $pdo->prepare('INSERT INTO feedbacks (account_id, user_id, question_id, message, status, created_at) VALUES (?, ?, ?, ?, "open", NOW())');
$ins->execute([$accId, $userId, $questionId, $message]);

json_ok(['saved' => true]);

