<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

$userId = current_user_id();

try {
    $pdo = db();
    $sql = 'SELECT question_id,
                   COALESCE(MIN(topic), "") AS topic,
                   COALESCE(MIN(difficulty), "") AS difficulty,
                   COUNT(*) AS attempts,
                   SUM(CASE WHEN is_correct = 1 THEN 1 ELSE 0 END) AS correct
            FROM attempts
            WHERE user_id = ?
            GROUP BY question_id';
    $st = $pdo->prepare($sql);
    $st->execute([$userId]);
    $rows = $st->fetchAll();

    $result = [];
    foreach ($rows as $r) {
        $attempts = (int)$r['attempts'];
        $correct = (int)$r['correct'];
        $mastery = $attempts > 0 ? ($correct / $attempts) : 0.0;
        $result[$r['question_id']] = [
            'topic' => $r['topic'],
            'difficulty' => $r['difficulty'],
            'attempts' => $attempts,
            'correct' => $correct,
            'mastery' => $mastery,
        ];
    }

    json_ok(['byQuestion' => $result]);
} catch (Throwable $e) {
    json_error('Failed to load mastery: ' . $e->getMessage(), 500);
}

