<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Return all active questions (for client cache, topics, etc.)
    $st = $pdo->query("SELECT id, type, topic, title, difficulty, explanation, code, question, options, correct_answer, task, initial_code, solution, expected_output FROM questions WHERE active = 1");
    $rows = $st->fetchAll();
    $data = array_map(function($r) {
        return normalize_question($r);
    }, $rows);
    json_ok(['questions' => $data]);
}

// POST: selection by difficulty counts or by topic
$in = json_input();
if (!$in) json_error('Missing body');

$topic = isset($in['topic']) ? trim((string)$in['topic']) : '';
if ($topic !== '') {
    $stmt = $pdo->prepare("SELECT id, type, topic, title, difficulty, explanation, code, question, options, correct_answer, task, initial_code, solution, expected_output FROM questions WHERE active = 1 AND topic = ?");
    $stmt->execute([$topic]);
    $rows = $stmt->fetchAll();
    shuffle_assoc($rows);
    $data = array_map(fn($r) => normalize_question($r), $rows);
    json_ok(['questions' => $data]);
}

$easy = (int)($in['easy'] ?? 0);
$medium = (int)($in['medium'] ?? 0);
$hard = (int)($in['hard'] ?? 0);

try {
    $data = [];
    foreach ([['easy',$easy],['medium',$medium],['hard',$hard]] as [$diff,$count]) {
        if ($count <= 0) continue;
        $stmt = $pdo->prepare("SELECT id, type, topic, title, difficulty, explanation, code, question, options, correct_answer, task, initial_code, solution, expected_output FROM questions WHERE active = 1 AND difficulty = ? ORDER BY RAND() LIMIT $count");
        $stmt->execute([$diff]);
        $rows = $stmt->fetchAll();
        foreach ($rows as $r) $data[] = normalize_question($r);
    }
    shuffle_assoc($data);
    json_ok(['questions' => $data]);
} catch (Throwable $e) {
    json_error('Failed to select questions: '.$e->getMessage(), 500);
}

function normalize_question(array $r): array {
    // Decode JSON options if present
    $opts = $r['options'];
    if (is_string($opts)) {
        $decoded = json_decode($opts, true);
        if (is_array($decoded)) $r['options'] = $decoded;
    }
    // Map server fields to client naming
    return [
        'id' => $r['id'],
        'type' => $r['type'],
        'topic' => $r['topic'],
        'title' => $r['title'],
        'difficulty' => $r['difficulty'],
        'explanation' => $r['explanation'],
        'code' => $r['code'],
        'question' => $r['question'],
        'options' => $r['options'] ?? null,
        'correctAnswer' => $r['correct_answer'],
        'task' => $r['task'],
        'initialCode' => $r['initial_code'],
        'solution' => $r['solution'],
        'expectedOutput' => $r['expected_output'],
    ];
}

function shuffle_assoc(array &$arr): void {
    if (empty($arr)) return;
    $keys = array_keys($arr);
    shuffle($keys);
    $new = [];
    foreach ($keys as $k) $new[] = $arr[$k];
    $arr = $new;
}

