USE adaptive_php;

-- Seed initial topics used by the question bank
INSERT INTO topics (name, created_at) VALUES
('Cơ bản', NOW()),
('Tương tác Web', NOW()),
('Điều khiển', NOW()),
('Xử lý Form', NOW()),
('Quản lý Phiên', NOW()),
('OOP', NOW()),
('Kết nối CSDL', NOW())
ON DUPLICATE KEY UPDATE name = VALUES(name);

-- Optional backfill from existing questions' topic values
INSERT INTO topics (name, created_at)
SELECT DISTINCT q.topic, NOW()
FROM questions q
WHERE q.topic IS NOT NULL AND q.topic <> ''
  AND NOT EXISTS (
    SELECT 1 FROM topics t WHERE t.name = q.topic
  );

